local PANEL = {};

// material
local arrow = surface.GetTextureID( "gui/arrow" );

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// lets store our angle!
	self.Expanded = false;
	
	// linked to
	self.LinkedClass = nil;
	
end


// on clicked
function PANEL:DoClick( )
	// set expanded!
	self.Expanded = !self.Expanded;
	
	// exec
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnExpanded", self.Expanded );
		
	end
	
end


// draw
function PANEL:Paint( )
	// calculate color.
	local alpha = 128;
	if( self.Armed && !self.Depressed ) then
		// adjust color, clamping to the valid range.
		alpha = 255;

	end
	
	// icon!
	local angle = 270;
	if( self.Expanded ) then angle = 90; end
	
	
	// fetch border color.
	local bgcolor = AppFramework:Theme().colors['window_face_sub'];
	
	// width/height
	local width, height = self:GetSize();
	
	
	// draw
	surface.SetTexture( arrow );
	surface.SetDrawColor( bgcolor.r, bgcolor.g, bgcolor.b, alpha );
	surface.DrawTexturedRectRotated(
		width * 0.5, height * 0.5,
		width, height,
		angle
	);
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_expandbutton", PANEL, "Button" );



// create app framework control.
CtlExpandButton_class 	= Control_class:create( nil, false, "ctl_expandbutton" );
